import usePreferences from "./usePreferences";

const useProcessPrice = () => {
    const {
        preference: {
            decimal_digits,
            symbol_position: position,
            thousand_separator,
            hide_decimal,
        } = {},
        company: { dflt_currency_symbol } = {},
    } = usePreferences();

    const processValue = (inputPrice) => {
        let stringPrice = String(inputPrice);
        let decimalSeparator = thousand_separator == "." ? "," : ".";
        let splitPrice = stringPrice?.includes(decimalSeparator)
            ? stringPrice.split(decimalSeparator)
            : stringPrice.split(".");
        let afterDecimalDigit =
            splitPrice.length > 1
                ? splitPrice[splitPrice.length - 1]?.slice(0, decimal_digits)
                : null;
        let haveDecimalDigit = afterDecimalDigit
            ? `${decimalSeparator}${afterDecimalDigit}`
            : "";
        let rawPrice = `${splitPrice[0]}${haveDecimalDigit}`;
        let result;
        let regexPattern = new RegExp("\\" + thousand_separator, "g");
        let price = String(rawPrice)?.replace(regexPattern, "");
        let num = price.split(decimalSeparator);
        let text = Number(num[0])
            .toString()
            .replace(/\B(?=(\d{3})+(?!\d))/g, thousand_separator);
        let isDecimalDigit = "";
        if (hide_decimal == 1 && num[1] == 0) {
            isDecimalDigit = "";
        } else if (hide_decimal == 1 && num[1] > 0) {
            isDecimalDigit = `${decimalSeparator}${String(num[1]).padEnd(Number(decimal_digits), "0")}`;
        } else if (hide_decimal == 0 && num[1] == undefined) {
            isDecimalDigit = `${decimalSeparator}${""
                .toString()
                .padEnd(Number(decimal_digits), "0")}`;
        } else {
            isDecimalDigit = num[1] ? `${decimalSeparator}${String(num[1]).padEnd(Number(decimal_digits), "0")}` : "";
        }
        text = `${text}${isDecimalDigit}`;
        if (position == "after") {
            result = `${text}${dflt_currency_symbol}`;
            return result;
        }
        result = `${dflt_currency_symbol}${text}`;
        return result;
    };
    return processValue;
};

export default useProcessPrice;
